#include <stdio.h>
#include <stdlib.h>

// ??? ?? ?????????? (long long ???? ?????????? -10^9 ?? 10^9)
typedef long long coord_t;

// ????????? ?? ?????
typedef struct {
    coord_t x;
    coord_t y;
    // ???? ?? ??????? ?? ?????????
    coord_t key1; // x + y
    coord_t key2; // x - y
    coord_t key3_y; // y
    int key3_x_parity; // x % 2
    coord_t key4_x; // x
    int key4_y_parity; // y % 2
} Point;

// ???????? ?????????? ?? ?????? ???? ????????
long long total_greetings = 0;

// ???????? ?? ???????????? ????? ?????? ? ????? ???????? count
long long combinations(long long count) {
    if (count < 2) return 0;
    return count * (count - 1) / 2;
}

// ----------------------------------------------------
// ????????? ?? qsort
// ----------------------------------------------------

// 1. ???????? ?? x + y (key1)
int compare_key1(const void *a, const void *b) {
    coord_t k1a = ((Point*)a)->key1;
    coord_t k1b = ((Point*)b)->key1;
    if (k1a < k1b) return -1;
    if (k1a > k1b) return 1;
    return 0;
}

// 2. ???????? ?? x - y (key2)
int compare_key2(const void *a, const void *b) {
    coord_t k2a = ((Point*)a)->key2;
    coord_t k2b = ((Point*)b)->key2;
    if (k2a < k2b) return -1;
    if (k2a > k2b) return 1;
    return 0;
}

// 3. ???????? ?? y, ?? ??????? x (key3)
int compare_key3(const void *a, const void *b) {
    coord_t k3ya = ((Point*)a)->key3_y;
    coord_t k3yb = ((Point*)b)->key3_y;

    if (k3ya < k3yb) return -1;
    if (k3ya > k3yb) return 1;

    int k3xa = ((Point*)a)->key3_x_parity;
    int k3xb = ((Point*)b)->key3_x_parity;
    return k3xa - k3xb;
}

// 4. ???????? ?? x, ?? ??????? y (key4)
int compare_key4(const void *a, const void *b) {
    coord_t k4xa = ((Point*)a)->key4_x;
    coord_t k4xb = ((Point*)b)->key4_x;

    if (k4xa < k4xb) return -1;
    if (k4xa > k4xb) return 1;

    int k4ya = ((Point*)a)->key4_y_parity;
    int k4yb = ((Point*)b)->key4_y_parity;
    return k4ya - k4yb;
}

// ----------------------------------------------------
// ?????? ???????? ?? ??????
// ----------------------------------------------------

void process_greetings(Point points[], int n) {
    
    // 0. ??????????????? ???????
    for (int i = 0; i < n; i++) {
        points[i].key1 = points[i].x + points[i].y;
        points[i].key2 = points[i].x - points[i].y;
        
        points[i].key3_y = points[i].y;
        // ?????? ???????? ???? ??????? ????????? ???????? ?? ????????? ???????, 
        // ?? ????????? ??????? ?? ????????? ?????????? ?? ???????.
        points[i].key3_x_parity = (points[i].x & 1) != 0; 
        
        points[i].key4_x = points[i].x;
        points[i].key4_y_parity = (points[i].y & 1) != 0;
    }

    // 1. ??????????? ??????? - ??? 1: x + y = ?????????
    qsort(points, n, sizeof(Point), compare_key1);
    
    long long current_count = 0;
    for (int i = 0; i < n; i++) {
        current_count++;
        if (i == n - 1 || points[i].key1 != points[i+1].key1) {
            // ????? ??? ???? 2 ????????
            total_greetings += 2 * combinations(current_count);
            current_count = 0;
        }
    }

    // 2. ??????????? ??????? - ??? 2: x - y = ?????????
    qsort(points, n, sizeof(Point), compare_key2);
    
    current_count = 0;
    for (int i = 0; i < n; i++) {
        current_count++;
        if (i == n - 1 || points[i].key2 != points[i+1].key2) {
            // ????? ??? ???? 2 ????????
            total_greetings += 2 * combinations(current_count);
            current_count = 0;
        }
    }

    // 3. ?????????? ???????: y = ????????? ? x ???? ????????
    qsort(points, n, sizeof(Point), compare_key3);

    current_count = 0;
    for (int i = 0; i < n; i++) {
        current_count++;
        // ??????? ????? ???? ??? ??????? ????? (??????? y ??? ??????? ???????? x)
        if (i == n - 1 || 
            points[i].key3_y != points[i+1].key3_y || 
            points[i].key3_x_parity != points[i+1].key3_x_parity) 
        {
            // ????? ??? ???? 2 ???????? (1 ?? ?-?, 1 ?? ?-?)
            total_greetings += 2 * combinations(current_count);
            current_count = 0;
        }
    }

    // 4. ???????????? ???????: x = ????????? ? y ???? ????????
    qsort(points, n, sizeof(Point), compare_key4);
    
    current_count = 0;
    for (int i = 0; i < n; i++) {
        current_count++;
        // ??????? ????? ???? ??? ??????? ????? (??????? x ??? ??????? ???????? y)
        if (i == n - 1 || 
            points[i].key4_x != points[i+1].key4_x || 
            points[i].key4_y_parity != points[i+1].key4_y_parity) 
        {
            // ????? ??? ???? 2 ???????? (1 ?? ?-?, 1 ?? ?-?)
            total_greetings += 2 * combinations(current_count);
            current_count = 0;
        }
    }
}

// ----------------------------------------------------
// main ????????
// ----------------------------------------------------

int main() {
    // ???????????? ?????/?????? (????? ?????? ? ???????????? ????????????)
    if (scanf("%d", &N) != 1) return 1;

    if (N < 2 || N > 200000) return 1;

    Point *points = (Point*) malloc(N * sizeof(Point));
    if (points == NULL) return 1; 

    for (int i = 0; i < N; i++) {
        if (scanf("%lld %lld", &points[i].x, &points[i].y) != 2) {
            free(points);
            return 1;
        }
    }

    process_greetings(points, N);

    printf("%lld\n", total_greetings);

    free(points);
    
    return 0;
}